import { rand, getRandomItem, clamp, shuffleArray } from "./tools/math.js";
import { Poster } from "./components/Poster.js";
import { initPanel } from "./components/Panel.js";
console.clear();

//// --- VARIABLES & OPTIONS
const poster = new Poster({ context: "2d" }),
    width = poster.innerWidth,
    height = poster.innerHeight,
    raf = window.requestAnimationFrame,
    cancelRaf = window.cancelAnimationFrame,
    options = {
        firstname: "Firstname",
        lastname: "Lastname",
        projectTitle: "Project title",
        schoolClass: "B3G",
        fullScreen: true,
    };

// --- TWEAKPANE
const values = {
    backgroundColor: "#000731",
    particleColor: "#ffe652",
};

const pane = initPanel(options, poster);

pane.addBinding(values, "particleColor").on("change", (e) => {
    poster.draw();
});

pane.addBinding(values, "backgroundColor").on("change", (e) => {
    poster.draw();
});

//// --- CUSTOM SETTINGS
// --- C'est ici que vous mettez vos foncions, classes, variables, etc.

class Particle {
    constructor() {
        this.x = rand(width, 0, { round: true });
        this.y = rand(height, 0, { round: true });
        this.radius = Math.round(width * rand(0.2, 0.05));
    }
}

const particles = [];
for (let i = 0; i < 1; i++) {
    particles.push(new Particle());
}

// DRAW
const draw = async (canvasOptions) => {
    // Regarder dans votre console pour voir
    // les informations de canvasOptions
    console.log(canvasOptions);

    // Le contexte pour dessiner
    const ctx = canvasOptions.ctx;

    ctx.fillStyle = values.backgroundColor;
    ctx.beginPath();
    ctx.rect(0, 0, width, height);
    ctx.fill();

    for (const p of particles) {
        ctx.fillStyle = values.particleColor;
        ctx.beginPath();
        ctx.arc(p.x, p.y, p.radius, 0, 2 * Math.PI);
        ctx.fill();
    }
};

// --- ANIMATION
const animate = (timestamp) => {
    // Votre logique d'animation

    // Ne pas toucher
    poster.draw();
    raf(animate);
};

//// --- CALLS
poster.setInfos(
    options.projectTitle,
    options.firstname,
    options.lastname,
    options.schoolClass
);
poster.setDrawing(draw);
poster.draw();
// raf( animate );

//// --- EVENTS
const onLoad = () => {
    poster.draw();
};
window.addEventListener("load", onLoad);
