import { rand, getRandomItem, clamp, shuffleArray } from "./tools/math.js";
import { Poster } from "./components/Poster.js";
import { initPanel } from "./components/Panel.js";
import * as THREE from "https://unpkg.com/three@0.180.0/build/three.module.js";
console.clear();

//// --- VARIABLES & OPTIONS
const poster = new Poster({ context: "3d", rendererOptions: { alpha: false } }),
    width = poster.innerWidth,
    height = poster.innerHeight,
    scene = poster.preview.innerCanvas.scene,
    raf = window.requestAnimationFrame,
    cancelRaf = window.cancelAnimationFrame,
    options = {
        firstname: "Firstname",
        lastname: "Lastname",
        projectTitle: "Project title",
        schoolClass: "B3G",
        fullScreen: true,
    };

// --- TWEAKPANE
const values = {
    backgroundColor: "#000731",
    particleColor: "#ffe652",
};

const pane = initPanel(options, poster);

pane.addBinding(values, "particleColor").on("change", (e) => {
    poster.draw();
});

pane.addBinding(values, "backgroundColor").on("change", (e) => {
    poster.draw();
});

//// --- CUSTOM SETTINGS
// --- C'est ici que vous mettez vos foncions, classes, variables, etc.

class Particle {
    constructor() {}
}

const particles = [];

for (let i = 0; i < 1; i++) {
    particles.push(new Particle());
}

const populate = () => {
    const geo = new THREE.BoxGeometry(3, 3, 3);
    const mat = new THREE.MeshBasicMaterial({ color: values.particleColor });
    const shape = new THREE.Mesh(geo, mat);

    scene.add(shape);
};

populate();

//// --- DRAW
// --- Votre logique de dessin 3D ici

const draw = async (canvasOptions) => {
    // Regarder dans votre console pour voir
    // les informations de canvasOptions
    console.log(canvasOptions);

    // Le renderer du canvas
    const renderer = canvasOptions.canvas.renderer;

    // Ne pas modifier
    return renderer.render(
        canvasOptions.canvas.scene,
        canvasOptions.canvas.camera
    );
};

// --- ANIMATION
const animate = (timestamp) => {
    // Votre logique d'animation

    // Ne pas toucher
    poster.draw();
    raf(animate);
};

//// --- CALLS
poster.setInfos(
    options.projectTitle,
    options.firstname,
    options.lastname,
    options.schoolClass
);
poster.setDrawing(draw);
poster.draw();
// raf( animate );

//// --- EVENTS
const onLoad = () => {
    poster.draw();
};

window.addEventListener("load", onLoad);
